#! /bin/sh


# This shell script changes both the SYSDBA user

#------------------------------------------------------------------------
# Prompt for response, store result in Answer

Answer=""

AskQuestion() {
    Test=$1
    DefaultAns=$2
    echo -n "${1}"
    Answer="$DefaultAns"
    read Answer
}


#------------------------------------------------------------------------
#  changeInitPassword


changeInitPassword() {

    NewPasswd=$1
    DBAPasswordFile=$FBRootDir/SYSDBA.password

    InitFile=/etc/rc.d/init.d/firebird
    if [ -f $InitFile ] 
      then
        echo ""
        echo Running ed to modify /etc/init.d/firebird

        ex $InitFile <<EOF
/ISC_PASSWORD/s/ISC_PASSWORD:=.*\}/ISC_PASSWORD:=$NewPasswd\}/g
w
q
EOF
    chmod u=rwx,g=rx,o= $InitFile

    fi
}


#------------------------------------------------------------------------
# Write new password to the /opt/firebird/SYSDBA.password file

writeNewPassword() {

    NewPasswd=$1
    DBAPasswordFile=$FBRootDir/SYSDBA.password

    echo "# Firebird generated password for user SYSDBA is: " > $DBAPasswordFile
    echo "" >> $DBAPasswordFile

    echo "ISC_USER=sysdba" >> $DBAPasswordFile
    echo "ISC_PASSWD=$NewPasswd" >> $DBAPasswordFile
    echo "" >> $DBAPasswordFile

    if [ $NewPasswd = "masterkey" ]
      then
        echo "# for install on `hostname` at time `date`" >> $DBAPasswordFile
        echo "# You should change this password at the earliest oportunity" >> $DBAPasswordFile
      else 
        echo "# generated on `hostname` at time `date`" >> $DBAPasswordFile
    fi
    echo "" >> $DBAPasswordFile
    echo "# Your password can be changed to a more suitable one using the" >> $DBAPasswordFile
    echo "# /opt/firebird/bin/changeDBAPassword.sh script" >> $DBAPasswordFile

    # Additional instructions for super server
    echo "" >> $DBAPasswordFile
    echo "# For superserver you will also want to check the password in the" >> $DBAPasswordFile
    echo "# daemon init routine in the file /etc/rc.d/init.d/firebird" >> $DBAPasswordFile

    echo "" >> $DBAPasswordFile
    chmod u=r,go= $DBAPasswordFile

}


#------------------------------------------------------------------------
#  Generate new sysdba password - this routine is used only in the 
#  rpm file not in the install acript.


generateNewDBAPassword() {


    # openssl generates random data.
    if [ -f /usr/bin/openssl ]
      then
        # We generate 20 random chars, strip any '/''s and get the first 8
        NewPasswd=`openssl rand -base64 20 | tr -d '/' | cut -c1-8`
    fi

    # mkpasswd is a bit of a hassle, but check to see if it's there
    if [ -z "$NewPasswd" ]
      then
        if [ -f /usr/bin/mkpasswd ]
          then
            NewPasswd=`/usr/bin/mkpasswd -l 8`
        fi
    fi


    # So we failed to generate a new password, so keep the original 
    # installed one.

    if [ -z "$NewPasswd" ]
      then
        NewPasswd="masterkey"
    fi

    writeNewPassword $NewPasswd
    changeInitPassword "$NewPasswd"

}





#------------------------------------------------------------------------
#  Change sysdba password - this routine is interactive and is only 
#  used in the install shell script not the rpm one.


askUserForNewDBAPassword() {

    OrigPasswd=""
    while [ -z "$OrigPasswd" ]
      do
          AskQuestion "Please enter current password for SYSDBA user: "
          OrigPasswd=$Answer
          
      done

    NewPasswd=""

    while [ -z "$NewPasswd" ]
      do
          AskQuestion "Please enter new password for SYSDBA user: "
          NewPasswd=$Answer
          if [ ! -z "$NewPasswd" ]
            then
             $FBBin/gsec -user sysdba -password $OrigPasswd <<EOF
modify sysdba -pw $NewPasswd
EOF
              echo ""

              writeNewPassword $NewPasswd
              changeInitPassword "$NewPasswd"

          fi
          
      done
}


#------------------------------------------------------------------------
#  Change sysdba password - this routine is interactive and is only 
#  used in the install shell script not the rpm one.


changeDBAPassword() {

    if [ -z "$InteractiveInstall" ]
      then
        generateNewDBAPassword
      else
        askUserForNewDBAPassword
    fi
}


#= Main Post ===============================================================


    FBRootDir=/opt/firebird
    FBBin=$FBRootDir/bin
    RunUser=root

    InteractiveInstall=true
    export InteractiveInstall

    changeDBAPassword
