#! /bin/sh
#
#  This library is part of the FirebirdSQL project
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#  You may obtain a copy of the Licence at
#  http://www.gnu.org/licences/lgpl.html
#  
#  As a special exception this file can also be included in modules
#  with other source code as long as that source code has been 
#  released under an Open Source Initiative certificed licence.  
#  More information about OSI certification can be found at: 
#  http://www.opensource.org 
#  
#  This module is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public Licence for more details.
#  
#  This module was created by members of the firebird development 
#  team.  All individual contributions remain the Copyright (C) of 
#  those individuals and all rights are reserved.  Contributors to 
#  this file are either listed below or can be obtained from a CVS 
#  history command.
# 
#   Created by:  Mark O'Donohue <mark.odonohue@ludwig.edu.au>
# 
#   Contributor(s):
#  
# 
#   $Id: taruninstall.sh.in,v 1.1.2.1 2004/01/29 13:37:20 alexpeshkoff Exp $
# 


#------------------------------------------------------------------------
# removeInstalledFiles
# 
removeInstalledFiles() {

    manifestFile=$FBRootDir/misc/manifest.txt

    if [ ! -f  $manifestFile ]
      then
        return
    fi

    origDir=`pwd`
    
    cd /

    for i in `cat $manifestFile`
      do
        if [ -f $i -o -L $i ]
          then
            rm -f $i
            #echo $i
        fi
    done

    cd "$origDir"
}


#------------------------------------------------------------------------
# removeUninstallFiles
# Under the install directory remove all the empty directories 
# If some files remain then 

removeUninstallFiles() {
    # remove the uninstall scripts files.
    #echo $FBRootDir/misc/scripts
    rm -rf $FBRootDir/misc/scripts
    rm -f $FBRootDir/misc/manifest.txt
    rm -f $FBRootDir/bin/uninstall.sh

}


#------------------------------------------------------------------------
# removeEmptyDirs
# Under the install directory remove all the empty directories 
# If some files remain then 
# This routing loops, since deleting a directory possibly makes
# the parent empty as well

removeEmptyDirs() {

    dirContentChanged='yes'
    while [ ! -z $dirContentChanged ]
      do
        dirContentChanged=''
        for i in `find $FBRootDir -empty -type d -print`
          do
            rmdir $i
            dirContentChanged=$i
        done

        if [ ! -d $FBRootDir ]  # end loop if the FBRootDir was deleted.
          then
            dirContentChanged=''
        fi

      done
}


FBRootDir=/opt/firebird
FBBin=$FBRootDir/bin

removeInstalledFiles  # Remove installed files 
removeUninstallFiles  # Remove the 'uninstall' utility files
removeEmptyDirs       # Remove empty directories
