#! /bin/sh


#------------------------------------------------------------------------
# remove line from config file if it exists in it.

removeLineFromFile() {
    FileName=$1
    oldLine=$2

    if [ ! -z "$oldLine" ] 
      then
        cat $FileName | grep -v "$oldLine" > ${FileName}.tmp
        mv ${FileName}.tmp $FileName
        echo "Updated."

    fi
}


#------------------------------------------------------------------------
#  removeLinksForBackCompatibility
#  Remove links for back compatibility to InterBase and Firebird1.0 
#  linked systems.

removeLinksForBackCompatibility() {

    if [ -L /usr/lib/libgds.so ]
      then
        rm -f /usr/lib/libgds.so
    fi
    if [ -L /usr/lib/libgds.so.0 ]
      then
        rm -f /usr/lib/libgds.so.0
    fi

}

#= Main PostUn ===============================================================


    if [ "$1"=0 ] 
      then 
    
        # Update /etc/services
        # Lose the gds_db line from /etc/services 
        # Leave it there, it was probably there already and does no
        # harm. MOD 7-Nov-2002

        #FileName=/etc/services
        #oldLine=`grep "^gds_db" $FileName`

        #removeLineFromFile "$FileName" "$oldLine"

        removeLinksForBackCompatibility


    # If we have right systems remove the service autoconfig stuff.
        if [ -x sbin/insserv ] 
          then
            sbin/insserv /etc/init.d/
        fi
        
        if [ -x sbin/chkconfig ] 
          then
            /sbin/chkconfig --del firebird
        fi

    # Remove /usr/sbin/rcfirebird symlink

        if [ -e /usr/sbin/rcfirebird ]
          then
            rm -f /usr/sbin/rcfirebird
        fi
        
    # Remove initd script
        
        if [ -e /etc/init.d/firebird ]
          then
            rm -f /etc/init.d/firebird
        fi
            
        if [ -e /etc/rc.d/init.d/firebird ] 
          then
            rm -f /etc/rc.d/init.d/firebird
        fi
    fi        
